package operating_system

// |@@| C

import (
	"context"
	erro "gardening/src/lib/error"
	"os"
	"path/filepath"
)

type OperatingSystemIpl struct {
}

func (this *OperatingSystemIpl) Kind() string {
	return "default"
}

func (this *OperatingSystemIpl) Getwd(ctx context.Context) (string, error) {
	return os.Getwd()
}

func (this *OperatingSystemIpl) Getenv(ctx context.Context, key string) string {
	return os.Getenv(key)
}

func (this *OperatingSystemIpl) Setenv(ctx context.Context, key string, value string) error {
	return os.Setenv(key, value)
}

func (this *OperatingSystemIpl) LookupEnv(ctx context.Context, key string) (string, bool) {
	return os.LookupEnv(key)
}

func (this *OperatingSystemIpl) Remove(ctx context.Context, name string) error {
	return os.Remove(name)
}

func (this *OperatingSystemIpl) RemoveAll(ctx context.Context, name string) error {
	return os.RemoveAll(name)
}

func (this *OperatingSystemIpl) WriteFile(ctx context.Context, name string, data []byte, perm os.FileMode) error {
	err := os.WriteFile(name, data, perm)
	if err != nil {
		return erro.W("Cannot write file", err).KV("name", name).KV("perm", perm.String())
	}
	return nil
}

func (this *OperatingSystemIpl) ReadDir(ctx context.Context, name string) ([]os.DirEntry, error) {
	return os.ReadDir(name)
}

func (this *OperatingSystemIpl) Stat(ctx context.Context, name string) (os.FileInfo, error) {
	return os.Stat(name)
}

func (this *OperatingSystemIpl) IsNotExist(ctx context.Context, err error) bool {
	return os.IsNotExist(err)
}

func (this *OperatingSystemIpl) ReadFile(ctx context.Context, name string) ([]byte, error) {
	return os.ReadFile(name)
}

func (this *OperatingSystemIpl) MkdirAll(ctx context.Context, path string, perm os.FileMode) error {
	return os.MkdirAll(path, perm)
}

func (this *OperatingSystemIpl) Rename(ctx context.Context, oldpath, newpath string) error {
	return os.Rename(oldpath, newpath)
}

func (this *OperatingSystemIpl) Walk(ctx context.Context, root string, fn filepath.WalkFunc) error {
	return filepath.Walk(root, fn)
}

func (this *OperatingSystemIpl) Chmod(ctx context.Context, name string, mode os.FileMode) error {
	return os.Chmod(name, mode)
}
