package relationer

// |@@| C

import (
	"context"
	"gardening/src/lib/fetcher"
)

type Relationer struct {
}

type RelationerMod struct {
	FetcherMod *fetcher.FetcherMod
}

func (this *Relationer) Mod() *RelationerMod {
	return &RelationerMod{}
}

func (this *Relationer) GetFetcherMod(mod *RelationerMod) *fetcher.FetcherMod {
	if mod == nil {
		return nil
	}
	return mod.FetcherMod
}

func (this *Relationer) GetUniqueIds(ctx context.Context, ranging func() []string) []string {
	m := make(map[string]string)
	var ids []string
	for _, id := range ranging() {
		if id == "" {
			continue
		}
		m[id] = id
	}
	for _, i := range m {
		ids = append(ids, i)
	}
	return ids
}

type Entity interface {
	GetId() string
}

func (this *Relationer) GetUniqueEntitiesIds(ctx context.Context, entities []Entity) []string {
	return this.GetUniqueIds(ctx, func() []string {
		var ids []string
		for _, entity := range entities {
			ids = append(ids, entity.GetId())
		}
		return ids
	})
}
