package router

// |@@| C

import (
	"gardening/src/lib/maestro"
	"github.com/gin-gonic/gin"
)

type Route interface {
	GetMethod() string
	GetRoutePath() string
	Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut)
}

type Router struct {
	MaeMiddleware *MaeMiddleware
}

func (this *Router) AddRoute(router *gin.RouterGroup, route Route) {
	router.Handle(route.GetMethod(), route.GetRoutePath(), this.MaeMiddleware.Act(route.Act, route))
}
