package sql

// |@@| C

import (
	"context"
	"database/sql"
)

const DRIVER_SQLITE3 = "sqlite3"
const DRIVER_POSTGRES = "postgres"

type Sql interface {
	Kind() string
	Driver() string
	SetMaxOpenConns(db *sql.DB, n int)
	Exec(db *sql.DB, query string, args ...any) (sql.Result, error)
	BeginTx(ctx context.Context, db *sql.DB, opts *sql.TxOptions) (*sql.Tx, error)
	Open(dataSourceName string) (*sql.DB, error)
	Query(db *sql.DB, query string, args ...any) (*sql.Rows, error)
	QueryRow(db *sql.DB, query string, args ...any) *sql.Row
	Prepare(db *sql.DB, query string) (*sql.Stmt, error)
	DataSourceName(ctx context.Context, rootDir string) string
	SchemaPath(ctx context.Context, rootDir string) string
	IsInMemory(ctx context.Context) bool
	Destroy(ctx context.Context, dataSourceName string)
	Create(ctx context.Context, dataSourceName string)
	Placeholder(n int) string
}
