package string_converter

import (
	"strconv"
	"strings"
	"time"
)

type StringConverter struct {
}

func (this *StringConverter) ConvertInt(value int) string {
	return strconv.Itoa(value)
}

func (this *StringConverter) ConvertBool(value bool, trueString string, falseString string) string {
	if value == true {
		return trueString
	}
	return falseString
}

func (this *StringConverter) ConvertFloat(value float64, precision int) string {
	return strconv.FormatFloat(value, 'f', precision, 64)
}

func (this *StringConverter) ConvertFloatComma(value float64, precision int) string {
	formatted := strconv.FormatFloat(value, 'f', precision, 64)
	return strings.Replace(formatted, ".", ",", 1)
}

func (this *StringConverter) ConvertTime(value time.Time, format string) string {
	return value.Format(format)
}

func (this *StringConverter) ConvertTimeFromDayToYear(value time.Time) string {
	return this.ConvertTime(value, "02-01-2006")
}

func (this *StringConverter) ConvertTimeFromYearToSecond(value time.Time) string {
	return this.ConvertTime(value, "02-01-2006 15:04:05")
}
