package time

// |@@| C

import (
	"github.com/benbjohnson/clock"
	"time"
)

type DeterministicTimeIpl struct {
	Data struct {
		Mock *clock.Mock
	}
}

func (this *DeterministicTimeIpl) Now() time.Time {
	mock := this.getMock()
	return mock.Now()
}

func (this *DeterministicTimeIpl) getMock() *clock.Mock {
	if this.Data.Mock != nil {
		return this.Data.Mock
	}
	mock := clock.NewMock()
	mock.Set(time.Date(2006, 1, 2, 15, 4, 5, 0, time.UTC))
	this.Data.Mock = mock
	return mock
}
