package to_json

// |@@| C

import (
	"encoding/json"
	"time"
)

func key(key string) string {
	return "\"" + key + "\": "
}

func encodeValue(name string, value interface{}) (string, error) {
	b, err := json.Marshal(value)
	if err != nil {
		return "", err
	}
	return key(name) + string(b), nil
}

func StringField(name string, value string) (string, error) {
	return encodeValue(name, value)
}

func JsonField(name string, value json.RawMessage) (string, error) {
	return encodeValue(name, string(value))
}

func StructField(name string, value interface{}) (string, error) {
	b, err := json.Marshal(value)
	if err != nil {
		return "", err
	}
	return encodeValue(name, b)
}

func IntegerField(name string, value int) (string, error) {
	return encodeValue(name, value)
}

func BooleanField(name string, value bool) (string, error) {
	return encodeValue(name, value)
}

func TimeField(name string, value time.Time) (string, error) {
	return encodeValue(name, value)
}

func DecimalField(name string, value float64) (string, error) {
	return encodeValue(name, value)
}
