package uploader

// |@@| C

import (
	"context"
	"gardening/src/lib/config"
	"gardening/src/lib/uuider"
	"path/filepath"
)

type FilesUploader struct {
	Config *config.Config
	Uuider *uuider.Uuider
}

func (this *FilesUploader) Upload(ctx context.Context, tmpFilePath string) string {
	_, fileName := filepath.Split(tmpFilePath)
	filepath.Join(this.TmpUploadDir(), fileName)
	return fileName
}

func (this *FilesUploader) TmpUploadDir() string {
	return "/tmp/_go_app_uploads"
}

func (this *FilesUploader) GenerateTmpUploadFilepath(ctx context.Context, filename string) string {
	extension := filepath.Ext(filename)
	return filepath.Join(this.TmpUploadDir(), this.Uuider.GenerateUuid()+extension)
}

func (this *FilesUploader) UploadDir() string {
	return this.Config.GetRootDir() + "/data/uploads"
}
