package urler

// |@@| C

import (
	"strconv"
	"strings"
)

type UrlParam struct {
	Key   string
	Value string
}

func IntParam(key string, value int) UrlParam {
	v := strconv.Itoa(value)
	return UrlParam{
		Key:   key,
		Value: v,
	}
}

func StringParam(key string, value string) UrlParam {
	return UrlParam{
		Key:   key,
		Value: value,
	}
}

func BoolParam(key string, value bool) UrlParam {
	v := "false"
	if value {
		v = "true"
	}
	return UrlParam{
		Key:   key,
		Value: v,
	}
}

func StringEqFilterParam(key string, value string) UrlParam {
	filterKey := "filters[fields][" + key + "][eq]"
	return StringParam(filterKey, value)
}

func Params(params []UrlParam) string {
	if len(params) < 1 {
		return ""
	}
	var ss []string
	for _, p := range params {
		ss = append(ss, p.Key+"="+p.Value)
	}

	return "?" + strings.Join(ss, "&")
}
