package uuider

// |@@| C

import (
	"crypto/rand"
	"encoding/hex"
)

type Uuider struct {
}

func (this *Uuider) GenerateUuid() string {
	var b [16]byte
	if _, err := rand.Read(b[:]); err != nil {
		panic(err)
	}
	b[6] = (b[6] & 0x0f) | 0x40 // Version 4
	b[8] = (b[8] & 0x3f) | 0x80 // Variant RFC4122

	uuid := make([]byte, 36)

	hex.Encode(uuid[0:8], b[0:4])
	uuid[8] = '-'
	hex.Encode(uuid[9:13], b[4:6])
	uuid[13] = '-'
	hex.Encode(uuid[14:18], b[6:8])
	uuid[18] = '-'
	hex.Encode(uuid[19:23], b[8:10])
	uuid[23] = '-'
	hex.Encode(uuid[24:36], b[10:16])

	return string(uuid)
}
