package validator

// |@@| C

import (
	"context"
	"gardening/src/lib/dev_tool"
	erro "gardening/src/lib/error"
	formLib "gardening/src/lib/form"
)

type Validator struct {
	DevTool *dev_tool.DevTool
}

type ValidatorMod struct {
}

type ValidateStringRequiredMod struct {
}

type ValidateIntegerRequired struct {
}

type ValidateIntegerMinMod struct {
	Min int
}

func (this *Validator) NewInvalidFormError(ctx context.Context, bag *formLib.FormBag) error {
	if this.DevTool.IsAvailable(ctx) {
		record := this.DevTool.GetCurrentRecord(ctx)
		record.FormBag = bag
	}

	return erro.NK("Invalid form", "validator.invalid_form")
}

func (this *Validator) MakeFormBag() *formLib.FormBag {
	return &formLib.FormBag{}
}

func (this *Validator) ValidateStringRequired(bag *formLib.FormBag, value string, field string, mod *ValidateStringRequiredMod) bool {
	if value != "" {
		return true
	}
	message := "This string field is required"
	bag.Invalidations = append(bag.Invalidations, &formLib.Invalidation{
		Field:   field,
		Message: message,
	})
	return false
}

type ValidateRelationIdRequiredMod struct {
}

func (this *Validator) ValidateRelationIdRequired(bag *formLib.FormBag, value string, field string, mod *ValidateRelationIdRequiredMod) bool {
	if value != "" {
		return true
	}
	message := "This relation field is required"
	bag.Invalidations = append(bag.Invalidations, &formLib.Invalidation{
		Field:   field,
		Message: message,
	})
	return false
}

func (this *Validator) ValidateIntegerRequired(bag *formLib.FormBag, value int, field string, mod *ValidateIntegerRequired) bool {
	if value != 0 {
		return true
	}
	message := "This integer field is required"
	bag.Invalidations = append(bag.Invalidations, &formLib.Invalidation{
		Field:   field,
		Message: message,
	})
	return false
}

func (this *Validator) ValidateIntegerMin(bag *formLib.FormBag, value int, field string, mod *ValidateIntegerMinMod) bool {
	if mod == nil {
		panic(erro.N("No mod passed to ValidateIntegerMin"))
	}

	if value < mod.Min {
		return true
	}
	message := "This integer field is lower than minimum value"
	bag.Invalidations = append(bag.Invalidations, &formLib.Invalidation{
		Field:   field,
		Message: message,
	})
	return false
}

func (this *Validator) IsValid(bag *formLib.FormBag) bool {
	if len(bag.Invalidations) > 0 {
		return false
	}
	return true
}
