package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_validators"
)

type ValidateFormStep struct {
	CreateGardenFormValidator *form_validators.CreateGardenFormValidator
	Maestro                   *maestro.Maestro
}

func (this *ValidateFormStep) Act(ctx context.Context, in *maes.CreateGardenMaeIn, out *maes.CreateGardenMaeOut) (bool, error) {
	bag, err := this.CreateGardenFormValidator.Validate(ctx, &in.Request.Form)
	out.Response.FormBag = bag
	if err != nil {
		this.Maestro.AddFailureMessage(&out.Extra, "Cannot submit form")
		return false, err
	}
	return true, nil
}
