package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/sql_db"
	"gardening/src/mae/create_garden"
	"gardening/src/srv/form_validators"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type CreateGardenMae struct {
	AuthorizeStep             *steps.AuthorizeStep
	ConfigureFormStep         *steps.ConfigureFormStep
	CreateGardenFormMolder    *molders.CreateGardenFormMolder
	CreateGardenFormValidator *form_validators.CreateGardenFormValidator
	GardenHandler             *handlers.GardenHandler
	Maestro                   *maestro.Maestro
	RecordEventStep           *steps.RecordEventStep
	SaveEntityStep            *steps.SaveEntityStep
	SqlDb                     *sql_db.SqlDb
	ValidateFormStep          *steps.ValidateFormStep
}

func (this *CreateGardenMae) Act(ctx context.Context, in *maes.CreateGardenMaeIn) (*maes.CreateGardenMaeOut, error) {
	out := &maes.CreateGardenMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.CreateGardenMaeIn, out *maes.CreateGardenMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureFormStep.Act,
		this.ValidateFormStep.Act,
		this.SaveEntityStep.Act,
		this.RecordEventStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
