package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_presenters"
)

type ConfigureFormStep struct {
	CreateGardenTaskFormPresenter *form_presenters.CreateGardenTaskFormPresenter
	Maestro                       *maestro.Maestro
}

func (this *ConfigureFormStep) Act(ctx context.Context, in *maes.CreateGardenTaskMaeIn, out *maes.CreateGardenTaskMaeOut) (bool, error) {
	out.Response.Form = in.Request.Form
	out.Response.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormFields = this.CreateGardenTaskFormPresenter.Setup(&out.Response.Form)

	return true, nil
}
