package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mdl"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type SaveEntityStep struct {
	CreateGardenTaskFormMolder *molders.CreateGardenTaskFormMolder
	GardenTaskHandler          *handlers.GardenTaskHandler
	Maestro                    *maestro.Maestro
}

func (this *SaveEntityStep) Act(ctx context.Context, in *maes.CreateGardenTaskMaeIn, out *maes.CreateGardenTaskMaeOut) (bool, error) {
	var err error
	entity := &mdl.GardenTask{}
	entity, _ = this.CreateGardenTaskFormMolder.ToEntity(&in.Request.Form, entity)
	out.Response.GardenTask, err = this.GardenTaskHandler.Create(ctx, entity, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "New garden task created")
	return true, nil
}
