package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_validators"
)

type ValidateFormStep struct {
	CreateGardenTaskFormValidator *form_validators.CreateGardenTaskFormValidator
	Maestro                       *maestro.Maestro
}

func (this *ValidateFormStep) Act(ctx context.Context, in *maes.CreateGardenTaskMaeIn, out *maes.CreateGardenTaskMaeOut) (bool, error) {
	bag, err := this.CreateGardenTaskFormValidator.Validate(ctx, &in.Request.Form)
	out.Response.FormBag = bag
	if err != nil {
		this.Maestro.AddFailureMessage(&out.Extra, "Cannot submit form")
		return false, err
	}
	return true, nil
}
