package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/sql_db"
	"gardening/src/mae/create_garden_task"
	"gardening/src/srv/form_validators"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type CreateGardenTaskMae struct {
	AuthorizeStep                 *steps.AuthorizeStep
	ConfigureFormStep             *steps.ConfigureFormStep
	CreateGardenTaskFormMolder    *molders.CreateGardenTaskFormMolder
	CreateGardenTaskFormValidator *form_validators.CreateGardenTaskFormValidator
	GardenTaskHandler             *handlers.GardenTaskHandler
	Maestro                       *maestro.Maestro
	RecordEventStep               *steps.RecordEventStep
	SaveEntityStep                *steps.SaveEntityStep
	SqlDb                         *sql_db.SqlDb
	ValidateFormStep              *steps.ValidateFormStep
}

func (this *CreateGardenTaskMae) Act(ctx context.Context, in *maes.CreateGardenTaskMaeIn) (*maes.CreateGardenTaskMaeOut, error) {
	out := &maes.CreateGardenTaskMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.CreateGardenTaskMaeIn, out *maes.CreateGardenTaskMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureFormStep.Act,
		this.ValidateFormStep.Act,
		this.SaveEntityStep.Act,
		this.RecordEventStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
