package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_presenters"
)

type ConfigureFormStep struct {
	CreatePlantFormPresenter *form_presenters.CreatePlantFormPresenter
	Maestro                  *maestro.Maestro
}

func (this *ConfigureFormStep) Act(ctx context.Context, in *maes.CreatePlantMaeIn, out *maes.CreatePlantMaeOut) (bool, error) {
	out.Response.Form = in.Request.Form
	out.Response.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormFields = this.CreatePlantFormPresenter.Setup(&out.Response.Form)

	return true, nil
}
