package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mdl"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type SaveEntityStep struct {
	CreatePlantFormMolder *molders.CreatePlantFormMolder
	Maestro               *maestro.Maestro
	PlantHandler          *handlers.PlantHandler
}

func (this *SaveEntityStep) Act(ctx context.Context, in *maes.CreatePlantMaeIn, out *maes.CreatePlantMaeOut) (bool, error) {
	var err error
	entity := &mdl.Plant{}
	entity, _ = this.CreatePlantFormMolder.ToEntity(&in.Request.Form, entity)
	out.Response.Plant, err = this.PlantHandler.Create(ctx, entity, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "New plant created")
	return true, nil
}
