package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/sql_db"
	"gardening/src/mae/create_plant"
	"gardening/src/srv/form_validators"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type CreatePlantMae struct {
	AuthorizeStep            *steps.AuthorizeStep
	ConfigureFormStep        *steps.ConfigureFormStep
	CreatePlantFormMolder    *molders.CreatePlantFormMolder
	CreatePlantFormValidator *form_validators.CreatePlantFormValidator
	Maestro                  *maestro.Maestro
	PlantHandler             *handlers.PlantHandler
	RecordEventStep          *steps.RecordEventStep
	SaveEntityStep           *steps.SaveEntityStep
	SqlDb                    *sql_db.SqlDb
	ValidateFormStep         *steps.ValidateFormStep
}

func (this *CreatePlantMae) Act(ctx context.Context, in *maes.CreatePlantMaeIn) (*maes.CreatePlantMaeOut, error) {
	out := &maes.CreatePlantMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.CreatePlantMaeIn, out *maes.CreatePlantMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureFormStep.Act,
		this.ValidateFormStep.Act,
		this.SaveEntityStep.Act,
		this.RecordEventStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
