package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mdl"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type SaveEntityStep struct {
	CreatePlantTaskFormMolder *molders.CreatePlantTaskFormMolder
	Maestro                   *maestro.Maestro
	PlantTaskHandler          *handlers.PlantTaskHandler
}

func (this *SaveEntityStep) Act(ctx context.Context, in *maes.CreatePlantTaskMaeIn, out *maes.CreatePlantTaskMaeOut) (bool, error) {
	var err error
	entity := &mdl.PlantTask{}
	entity, _ = this.CreatePlantTaskFormMolder.ToEntity(&in.Request.Form, entity)
	out.Response.PlantTask, err = this.PlantTaskHandler.Create(ctx, entity, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "New plant task created")
	return true, nil
}
