package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_validators"
)

type ValidateFormStep struct {
	CreatePlantTaskFormValidator *form_validators.CreatePlantTaskFormValidator
	Maestro                      *maestro.Maestro
}

func (this *ValidateFormStep) Act(ctx context.Context, in *maes.CreatePlantTaskMaeIn, out *maes.CreatePlantTaskMaeOut) (bool, error) {
	bag, err := this.CreatePlantTaskFormValidator.Validate(ctx, &in.Request.Form)
	out.Response.FormBag = bag
	if err != nil {
		this.Maestro.AddFailureMessage(&out.Extra, "Cannot submit form")
		return false, err
	}
	return true, nil
}
