package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/sql_db"
	"gardening/src/mae/create_plant_task"
	"gardening/src/srv/form_validators"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type CreatePlantTaskMae struct {
	AuthorizeStep                *steps.AuthorizeStep
	ConfigureFormStep            *steps.ConfigureFormStep
	CreatePlantTaskFormMolder    *molders.CreatePlantTaskFormMolder
	CreatePlantTaskFormValidator *form_validators.CreatePlantTaskFormValidator
	Maestro                      *maestro.Maestro
	PlantTaskHandler             *handlers.PlantTaskHandler
	RecordEventStep              *steps.RecordEventStep
	SaveEntityStep               *steps.SaveEntityStep
	SqlDb                        *sql_db.SqlDb
	ValidateFormStep             *steps.ValidateFormStep
}

func (this *CreatePlantTaskMae) Act(ctx context.Context, in *maes.CreatePlantTaskMaeIn) (*maes.CreatePlantTaskMaeOut, error) {
	out := &maes.CreatePlantTaskMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.CreatePlantTaskMaeIn, out *maes.CreatePlantTaskMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureFormStep.Act,
		this.ValidateFormStep.Act,
		this.SaveEntityStep.Act,
		this.RecordEventStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
