package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_presenters"
)

type ConfigureFormStep struct {
	CreatePlantationFormPresenter *form_presenters.CreatePlantationFormPresenter
	Maestro                       *maestro.Maestro
}

func (this *ConfigureFormStep) Act(ctx context.Context, in *maes.CreatePlantationMaeIn, out *maes.CreatePlantationMaeOut) (bool, error) {
	out.Response.Form = in.Request.Form
	out.Response.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormFields = this.CreatePlantationFormPresenter.Setup(&out.Response.Form)

	return true, nil
}
