package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/handlers"
)

type RecordEventStep struct {
	EventHandler *handlers.EventHandler
	Maestro      *maestro.Maestro
}

func (this *RecordEventStep) Act(ctx context.Context, in *maes.CreatePlantationMaeIn, out *maes.CreatePlantationMaeOut) (bool, error) {
	event := this.Maestro.NewEvent(ctx)
	event.What = "create_plantation"
	event.ResourceId = out.Response.Plantation.Id
	event.ResourceType = "plantation"
	this.EventHandler.MustCreate(ctx, event, nil)
	return true, nil
}
