package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mdl"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type SaveEntityStep struct {
	CreatePlantationFormMolder *molders.CreatePlantationFormMolder
	Maestro                    *maestro.Maestro
	PlantationHandler          *handlers.PlantationHandler
}

func (this *SaveEntityStep) Act(ctx context.Context, in *maes.CreatePlantationMaeIn, out *maes.CreatePlantationMaeOut) (bool, error) {
	var err error
	entity := &mdl.Plantation{}
	entity, _ = this.CreatePlantationFormMolder.ToEntity(&in.Request.Form, entity)
	out.Response.Plantation, err = this.PlantationHandler.Create(ctx, entity, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "New plantation created")
	return true, nil
}
