package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_validators"
)

type ValidateFormStep struct {
	CreatePlantationFormValidator *form_validators.CreatePlantationFormValidator
	Maestro                       *maestro.Maestro
}

func (this *ValidateFormStep) Act(ctx context.Context, in *maes.CreatePlantationMaeIn, out *maes.CreatePlantationMaeOut) (bool, error) {
	bag, err := this.CreatePlantationFormValidator.Validate(ctx, &in.Request.Form)
	out.Response.FormBag = bag
	if err != nil {
		this.Maestro.AddFailureMessage(&out.Extra, "Cannot submit form")
		return false, err
	}
	return true, nil
}
