package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/sql_db"
	"gardening/src/mae/create_plantation"
	"gardening/src/srv/form_validators"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type CreatePlantationMae struct {
	AuthorizeStep                 *steps.AuthorizeStep
	ConfigureFormStep             *steps.ConfigureFormStep
	CreatePlantationFormMolder    *molders.CreatePlantationFormMolder
	CreatePlantationFormValidator *form_validators.CreatePlantationFormValidator
	Maestro                       *maestro.Maestro
	PlantationHandler             *handlers.PlantationHandler
	RecordEventStep               *steps.RecordEventStep
	SaveEntityStep                *steps.SaveEntityStep
	SqlDb                         *sql_db.SqlDb
	ValidateFormStep              *steps.ValidateFormStep
}

func (this *CreatePlantationMae) Act(ctx context.Context, in *maes.CreatePlantationMaeIn) (*maes.CreatePlantationMaeOut, error) {
	out := &maes.CreatePlantationMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.CreatePlantationMaeIn, out *maes.CreatePlantationMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureFormStep.Act,
		this.ValidateFormStep.Act,
		this.SaveEntityStep.Act,
		this.RecordEventStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
