package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_presenters"
)

type ConfigureFormStep struct {
	CreateSeedProgramFormPresenter *form_presenters.CreateSeedProgramFormPresenter
	Maestro                        *maestro.Maestro
}

func (this *ConfigureFormStep) Act(ctx context.Context, in *maes.CreateSeedProgramMaeIn, out *maes.CreateSeedProgramMaeOut) (bool, error) {
	out.Response.Form = in.Request.Form
	out.Response.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormFields = this.CreateSeedProgramFormPresenter.Setup(&out.Response.Form)

	return true, nil
}
