package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/handlers"
)

type RecordEventStep struct {
	EventHandler *handlers.EventHandler
	Maestro      *maestro.Maestro
}

func (this *RecordEventStep) Act(ctx context.Context, in *maes.CreateSeedProgramMaeIn, out *maes.CreateSeedProgramMaeOut) (bool, error) {
	event := this.Maestro.NewEvent(ctx)
	event.What = "create_seed_program"
	event.ResourceId = out.Response.SeedProgram.Id
	event.ResourceType = "seed_program"
	this.EventHandler.MustCreate(ctx, event, nil)
	return true, nil
}
