package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mdl"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type SaveEntityStep struct {
	CreateSeedProgramFormMolder *molders.CreateSeedProgramFormMolder
	Maestro                     *maestro.Maestro
	SeedProgramHandler          *handlers.SeedProgramHandler
}

func (this *SaveEntityStep) Act(ctx context.Context, in *maes.CreateSeedProgramMaeIn, out *maes.CreateSeedProgramMaeOut) (bool, error) {
	var err error
	entity := &mdl.SeedProgram{}
	entity, _ = this.CreateSeedProgramFormMolder.ToEntity(&in.Request.Form, entity)
	out.Response.SeedProgram, err = this.SeedProgramHandler.Create(ctx, entity, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "New seed program created")
	return true, nil
}
