package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/sql_db"
	"gardening/src/mae/create_seed_program"
	"gardening/src/srv/form_validators"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type CreateSeedProgramMae struct {
	AuthorizeStep                  *steps.AuthorizeStep
	ConfigureFormStep              *steps.ConfigureFormStep
	CreateSeedProgramFormMolder    *molders.CreateSeedProgramFormMolder
	CreateSeedProgramFormValidator *form_validators.CreateSeedProgramFormValidator
	Maestro                        *maestro.Maestro
	RecordEventStep                *steps.RecordEventStep
	SaveEntityStep                 *steps.SaveEntityStep
	SeedProgramHandler             *handlers.SeedProgramHandler
	SqlDb                          *sql_db.SqlDb
	ValidateFormStep               *steps.ValidateFormStep
}

func (this *CreateSeedProgramMae) Act(ctx context.Context, in *maes.CreateSeedProgramMaeIn) (*maes.CreateSeedProgramMaeOut, error) {
	out := &maes.CreateSeedProgramMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.CreateSeedProgramMaeIn, out *maes.CreateSeedProgramMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureFormStep.Act,
		this.ValidateFormStep.Act,
		this.SaveEntityStep.Act,
		this.RecordEventStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
