package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/handlers"
)

type RecordEventStep struct {
	EventHandler *handlers.EventHandler
	Maestro      *maestro.Maestro
}

func (this *RecordEventStep) Act(ctx context.Context, in *maes.CreateUserMaeIn, out *maes.CreateUserMaeOut) (bool, error) {
	event := this.Maestro.NewEvent(ctx)
	event.What = "create_user"
	event.ResourceId = out.Response.User.Id
	event.ResourceType = "user"
	this.EventHandler.MustCreate(ctx, event, nil)
	return true, nil
}
