package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mdl"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type SaveEntityStep struct {
	CreateUserFormMolder *molders.CreateUserFormMolder
	Maestro              *maestro.Maestro
	UserHandler          *handlers.UserHandler
}

func (this *SaveEntityStep) Act(ctx context.Context, in *maes.CreateUserMaeIn, out *maes.CreateUserMaeOut) (bool, error) {
	var err error
	entity := &mdl.User{}
	entity, _ = this.CreateUserFormMolder.ToEntity(&in.Request.Form, entity)
	out.Response.User, err = this.UserHandler.Create(ctx, entity, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "New user created")
	return true, nil
}
