package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/sql_db"
	"gardening/src/mae/create_user"
	"gardening/src/srv/form_validators"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type CreateUserMae struct {
	AuthorizeStep           *steps.AuthorizeStep
	ConfigureFormStep       *steps.ConfigureFormStep
	CreateUserFormMolder    *molders.CreateUserFormMolder
	CreateUserFormValidator *form_validators.CreateUserFormValidator
	Maestro                 *maestro.Maestro
	RecordEventStep         *steps.RecordEventStep
	SaveEntityStep          *steps.SaveEntityStep
	SqlDb                   *sql_db.SqlDb
	UserHandler             *handlers.UserHandler
	ValidateFormStep        *steps.ValidateFormStep
}

func (this *CreateUserMae) Act(ctx context.Context, in *maes.CreateUserMaeIn) (*maes.CreateUserMaeOut, error) {
	out := &maes.CreateUserMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.CreateUserMaeIn, out *maes.CreateUserMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureFormStep.Act,
		this.ValidateFormStep.Act,
		this.SaveEntityStep.Act,
		this.RecordEventStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
