package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
)

type DeleteEntityStep struct {
	GardenFetcher *fetchers.GardenFetcher
	GardenHandler *handlers.GardenHandler
	Maestro       *maestro.Maestro
}

func (this *DeleteEntityStep) Act(ctx context.Context, in *maes.DeleteGardenMaeIn, out *maes.DeleteGardenMaeOut) (bool, error) {
	id := in.Request.Id
	mod := this.GardenFetcher.Mod()
	garden, has, err := this.GardenFetcher.FindOneById(ctx, id, mod)
	if err != nil {
		return false, err
	}
	if !has {
		panic("No entity")
	}
	err = this.GardenHandler.Delete(ctx, garden, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "Deleted")
	return true, nil
}
