package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/delete_garden"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
)

type DeleteGardenMae struct {
	AuthorizeStep    *steps.AuthorizeStep
	DeleteEntityStep *steps.DeleteEntityStep
	GardenFetcher    *fetchers.GardenFetcher
	GardenHandler    *handlers.GardenHandler
	Maestro          *maestro.Maestro
}

func (this *DeleteGardenMae) Act(ctx context.Context, in *maes.DeleteGardenMaeIn) (*maes.DeleteGardenMaeOut, error) {
	out := &maes.DeleteGardenMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.DeleteGardenMaeIn, out *maes.DeleteGardenMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.DeleteEntityStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
