package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
)

type DeleteEntityStep struct {
	GardenTaskFetcher *fetchers.GardenTaskFetcher
	GardenTaskHandler *handlers.GardenTaskHandler
	Maestro           *maestro.Maestro
}

func (this *DeleteEntityStep) Act(ctx context.Context, in *maes.DeleteGardenTaskMaeIn, out *maes.DeleteGardenTaskMaeOut) (bool, error) {
	id := in.Request.Id
	mod := this.GardenTaskFetcher.Mod()
	garden, has, err := this.GardenTaskFetcher.FindOneById(ctx, id, mod)
	if err != nil {
		return false, err
	}
	if !has {
		panic("No entity")
	}
	err = this.GardenTaskHandler.Delete(ctx, garden, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "Deleted")
	return true, nil
}
