package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/delete_garden_task"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
)

type DeleteGardenTaskMae struct {
	AuthorizeStep     *steps.AuthorizeStep
	DeleteEntityStep  *steps.DeleteEntityStep
	GardenTaskFetcher *fetchers.GardenTaskFetcher
	GardenTaskHandler *handlers.GardenTaskHandler
	Maestro           *maestro.Maestro
}

func (this *DeleteGardenTaskMae) Act(ctx context.Context, in *maes.DeleteGardenTaskMaeIn) (*maes.DeleteGardenTaskMaeOut, error) {
	out := &maes.DeleteGardenTaskMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.DeleteGardenTaskMaeIn, out *maes.DeleteGardenTaskMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.DeleteEntityStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
