package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
)

type DeleteEntityStep struct {
	Maestro      *maestro.Maestro
	PlantFetcher *fetchers.PlantFetcher
	PlantHandler *handlers.PlantHandler
}

func (this *DeleteEntityStep) Act(ctx context.Context, in *maes.DeletePlantMaeIn, out *maes.DeletePlantMaeOut) (bool, error) {
	id := in.Request.Id
	mod := this.PlantFetcher.Mod()
	garden, has, err := this.PlantFetcher.FindOneById(ctx, id, mod)
	if err != nil {
		return false, err
	}
	if !has {
		panic("No entity")
	}
	err = this.PlantHandler.Delete(ctx, garden, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "Deleted")
	return true, nil
}
