package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/delete_plant"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
)

type DeletePlantMae struct {
	AuthorizeStep    *steps.AuthorizeStep
	DeleteEntityStep *steps.DeleteEntityStep
	Maestro          *maestro.Maestro
	PlantFetcher     *fetchers.PlantFetcher
	PlantHandler     *handlers.PlantHandler
}

func (this *DeletePlantMae) Act(ctx context.Context, in *maes.DeletePlantMaeIn) (*maes.DeletePlantMaeOut, error) {
	out := &maes.DeletePlantMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.DeletePlantMaeIn, out *maes.DeletePlantMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.DeleteEntityStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
