package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
)

type DeleteEntityStep struct {
	Maestro          *maestro.Maestro
	PlantTaskFetcher *fetchers.PlantTaskFetcher
	PlantTaskHandler *handlers.PlantTaskHandler
}

func (this *DeleteEntityStep) Act(ctx context.Context, in *maes.DeletePlantTaskMaeIn, out *maes.DeletePlantTaskMaeOut) (bool, error) {
	id := in.Request.Id
	mod := this.PlantTaskFetcher.Mod()
	garden, has, err := this.PlantTaskFetcher.FindOneById(ctx, id, mod)
	if err != nil {
		return false, err
	}
	if !has {
		panic("No entity")
	}
	err = this.PlantTaskHandler.Delete(ctx, garden, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "Deleted")
	return true, nil
}
