package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/delete_plant_task"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
)

type DeletePlantTaskMae struct {
	AuthorizeStep    *steps.AuthorizeStep
	DeleteEntityStep *steps.DeleteEntityStep
	Maestro          *maestro.Maestro
	PlantTaskFetcher *fetchers.PlantTaskFetcher
	PlantTaskHandler *handlers.PlantTaskHandler
}

func (this *DeletePlantTaskMae) Act(ctx context.Context, in *maes.DeletePlantTaskMaeIn) (*maes.DeletePlantTaskMaeOut, error) {
	out := &maes.DeletePlantTaskMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.DeletePlantTaskMaeIn, out *maes.DeletePlantTaskMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.DeleteEntityStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
