package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
)

type DeleteEntityStep struct {
	Maestro           *maestro.Maestro
	PlantationFetcher *fetchers.PlantationFetcher
	PlantationHandler *handlers.PlantationHandler
}

func (this *DeleteEntityStep) Act(ctx context.Context, in *maes.DeletePlantationMaeIn, out *maes.DeletePlantationMaeOut) (bool, error) {
	id := in.Request.Id
	mod := this.PlantationFetcher.Mod()
	garden, has, err := this.PlantationFetcher.FindOneById(ctx, id, mod)
	if err != nil {
		return false, err
	}
	if !has {
		panic("No entity")
	}
	err = this.PlantationHandler.Delete(ctx, garden, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "Deleted")
	return true, nil
}
