package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/delete_plantation"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
)

type DeletePlantationMae struct {
	AuthorizeStep     *steps.AuthorizeStep
	DeleteEntityStep  *steps.DeleteEntityStep
	Maestro           *maestro.Maestro
	PlantationFetcher *fetchers.PlantationFetcher
	PlantationHandler *handlers.PlantationHandler
}

func (this *DeletePlantationMae) Act(ctx context.Context, in *maes.DeletePlantationMaeIn) (*maes.DeletePlantationMaeOut, error) {
	out := &maes.DeletePlantationMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.DeletePlantationMaeIn, out *maes.DeletePlantationMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.DeleteEntityStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
