package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
)

type DeleteEntityStep struct {
	Maestro            *maestro.Maestro
	SeedProgramFetcher *fetchers.SeedProgramFetcher
	SeedProgramHandler *handlers.SeedProgramHandler
}

func (this *DeleteEntityStep) Act(ctx context.Context, in *maes.DeleteSeedProgramMaeIn, out *maes.DeleteSeedProgramMaeOut) (bool, error) {
	id := in.Request.Id
	mod := this.SeedProgramFetcher.Mod()
	garden, has, err := this.SeedProgramFetcher.FindOneById(ctx, id, mod)
	if err != nil {
		return false, err
	}
	if !has {
		panic("No entity")
	}
	err = this.SeedProgramHandler.Delete(ctx, garden, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "Deleted")
	return true, nil
}
