package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/delete_seed_program"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
)

type DeleteSeedProgramMae struct {
	AuthorizeStep      *steps.AuthorizeStep
	DeleteEntityStep   *steps.DeleteEntityStep
	Maestro            *maestro.Maestro
	SeedProgramFetcher *fetchers.SeedProgramFetcher
	SeedProgramHandler *handlers.SeedProgramHandler
}

func (this *DeleteSeedProgramMae) Act(ctx context.Context, in *maes.DeleteSeedProgramMaeIn) (*maes.DeleteSeedProgramMaeOut, error) {
	out := &maes.DeleteSeedProgramMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.DeleteSeedProgramMaeIn, out *maes.DeleteSeedProgramMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.DeleteEntityStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
