package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
)

type DeleteEntityStep struct {
	Maestro     *maestro.Maestro
	UserFetcher *fetchers.UserFetcher
	UserHandler *handlers.UserHandler
}

func (this *DeleteEntityStep) Act(ctx context.Context, in *maes.DeleteUserMaeIn, out *maes.DeleteUserMaeOut) (bool, error) {
	id := in.Request.Id
	mod := this.UserFetcher.Mod()
	garden, has, err := this.UserFetcher.FindOneById(ctx, id, mod)
	if err != nil {
		return false, err
	}
	if !has {
		panic("No entity")
	}
	err = this.UserHandler.Delete(ctx, garden, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "Deleted")
	return true, nil
}
