package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/delete_user"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
)

type DeleteUserMae struct {
	AuthorizeStep    *steps.AuthorizeStep
	DeleteEntityStep *steps.DeleteEntityStep
	Maestro          *maestro.Maestro
	UserFetcher      *fetchers.UserFetcher
	UserHandler      *handlers.UserHandler
}

func (this *DeleteUserMae) Act(ctx context.Context, in *maes.DeleteUserMaeIn) (*maes.DeleteUserMaeOut, error) {
	out := &maes.DeleteUserMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.DeleteUserMaeIn, out *maes.DeleteUserMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.DeleteEntityStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
