package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/error"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/form_presenters"
	"gardening/src/srv/molders"
)

type ConfigureForm struct {
	GardenFetcher             *fetchers.GardenFetcher
	Maestro                   *maestro.Maestro
	UpdateGardenFormMolder    *molders.UpdateGardenFormMolder
	UpdateGardenFormPresenter *form_presenters.UpdateGardenFormPresenter
}

func (this *ConfigureForm) Act(ctx context.Context, in *maes.EditGardenMaeIn, out *maes.EditGardenMaeOut) (bool, error) {
	mod := this.GardenFetcher.Mod()
	entity, has, err := this.GardenFetcher.FindOneById(ctx, in.Request.Form.Id, mod)
	if !has {
		return false, erro.N("No entity")
	}
	if err != nil {
		return false, err
	}
	this.UpdateGardenFormMolder.ToForm(&out.Response.Form, entity)
	out.Response.Doc = entity
	out.Response.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormFields = this.UpdateGardenFormPresenter.Setup(&out.Response.Form)

	return true, nil
}
